# **Health Care Server**

Welcome to the **Health Care Server** project! This repository contains the server-side code for our Health Care application. This README file provides guidelines on how to build and contribute to the project as a team. Please make sure to follow these instructions to maintain a consistent and efficient development process.

## **Getting Started**

1. **Clone the Repository:**
    
    ```bash
    git clone https://github.com/Programming-Hero-Next-Level-Development/health-care-server.git
    ```
    
2. **Navigate to the Project Directory:**
    
    ```bash
    cd health-care-server
    ```
    
3. Please update the filename from `.env.example` to `.env`
4. **Install Dependencies:**
    
    ```bash
    yarn install
    ```
    
5. **Start the Server:**
    
    ```bash
    yarn dev
    ```
    
    The server will be running at **`http://localhost:3000`** .
    

## **Contributing Guidelines**

To contribute to the project, follow these guidelines:

1. **Create a Feature Branch:**
Before starting work on a new feature, create a feature branch:
    
    ```bash
    git checkout -b feature/your-feature-name
    ```
    
2. **Write Code:**
Implement the feature or fix the bug on your feature branch.
3. **Commit Changes:**
Commit your changes with a meaningful commit message:
    
    ```bash
    git commit -m "Add your commit message here"
    ```
    
4. **Push Changes:**
Push your changes to your feature branch:
    
    ```bash
    git push origin feature/your-feature-name
    ```
    
5. **Create a Pull Request (PR):**
Create a pull request from your feature branch to the **`development`** branch on GitHub. Ensure the PR title and description are descriptive.
6. **Code Review:**
Your code will be reviewed by other team members. Address any feedback and make necessary changes.

## **Additional Notes**

- **Main Branch:**
The **`main`** branch is reserved for stable releases. Do not directly push to the main branch.
- **Issues and Bug Tracking:**
Use the GitHub Issues tab to report bugs, suggest features, or discuss enhancements.
- **Coding Standards:**
Follow the coding standards and conventions established by the team. Ensure your code is well-documented.


#### Postman API Documentation: https://documenter.getpostman.com/view/26694209/2s9YynmjXH