import { Client } from './client';
import { Config, TokenSearchRules, TokenOptions } from '../types';
import { Token } from '../token';
declare class MeiliSearch extends Client {
    tokens: Token;
    constructor(config: Config);
    /**
     * Generate a tenant token
     *
     * @param apiKeyUid - The uid of the api key used as issuer of the token.
     * @param searchRules - Search rules that are applied to every search.
     * @param options - Token options to customize some aspect of the token.
     * @returns The token in JWT format.
     */
    generateTenantToken(apiKeyUid: string, searchRules: TokenSearchRules, options?: TokenOptions): Promise<string>;
}
export { MeiliSearch };
//# sourceMappingURL=node-client.d.ts.map