import { Config, TokenSearchRules, TokenOptions } from './types';
declare class Token {
    config: Config;
    constructor(config: Config);
    /**
     * Generate a tenant token
     *
     * @param apiKeyUid - The uid of the api key used as issuer of the token.
     * @param searchRules - Search rules that are applied to every search.
     * @param options - Token options to customize some aspect of the token.
     * @returns The token in JWT format.
     */
    generateTenantToken(apiKeyUid: string, searchRules: TokenSearchRules, options?: TokenOptions): Promise<string>;
}
export { Token };
//# sourceMappingURL=token.d.ts.map